// shared.js — tiny helper for polling + audio
const API = (p) => `/api/${p}`;
export { API };

export async function getJSON(url){
  const r = await fetch(url);
  if(!r.ok) throw new Error('Network error');
  return r.json();
}

export async function postJSON(url, data){
  const r = await fetch(url, {method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(data)});
  return r.json();
}

export async function patchForm(url, data){
  const r = await fetch(url, {method:'PATCH', headers:{'Content-Type':'application/x-www-form-urlencoded'}, body: new URLSearchParams(data)});
  return r.json();
}

export function beep(){
  const a = document.getElementById('beep');
  if(a){ a.currentTime = 0; a.play().catch(()=>{}); }
}

export async function heartbeatLoop(onChange){
  let v = 0;
  while(true){
    try{
      const res = await getJSON(API(`heartbeat.php?v=${v}`));
      if(res.changed){ v = res.version; await onChange(); beep(); }
      await new Promise(r=>setTimeout(r, 2000));
    }catch(e){ await new Promise(r=>setTimeout(r, 3000)); }
  }
}
