<?php
// install.php — run schema.sql to create required tables
// 1) Upload this file and schema.sql + db.php + .env to the same folder on your server
// 2) Visit /install.php in your browser
// 3) Delete install.php after success for security
require __DIR__.'/db.php';
header('Content-Type: text/html; charset=utf-8');
echo "<h2>Kitchen/FOH App — Installer</h2>";
echo "<pre>";
try {
  $pdo = pdo();
  echo "Connected to DB '".htmlspecialchars(env('DB_NAME'), ENT_QUOTES)."' as '".htmlspecialchars(env('DB_USER'), ENT_QUOTES)."'.\n\n";

  $path = __DIR__ . '/schema.sql';
  if (!file_exists($path)) { throw new Exception("schema.sql not found at $path"); }
  $sql = file_get_contents($path);

  // Split into statements (naive but works for our file)
  $lines = preg_split('/\R/', $sql);
  $buf = '';
  $count = 0;
  foreach ($lines as $line) {
    $trim = trim($line);
    if ($trim === '' || strpos($trim, '--') === 0) continue; // skip comments/blank
    $buf .= $line . "\n";
    if (substr(rtrim($line), -1) === ';') {
      $stmt = trim($buf);
      if ($stmt !== '') {
        $pdo->exec($stmt);
        $first = substr(preg_replace('/\s+/', ' ', $stmt), 0, 80);
        echo "OK: $first...\n";
        $count++;
      }
      $buf = '';
    }
  }
  if (trim($buf) !== '') { $pdo->exec($buf); $count++; }

  echo "\nExecuted $count statements.\n";

  // Quick checks
  $checkTables = ['staff','productions','orders','order_items','order_events','bumps'];
  foreach ($checkTables as $t) {
    $q = $pdo->prepare("SHOW TABLES LIKE ?"); $q->execute([$t]);
    echo ($q->rowCount() ? "✓" : "✗") . " $t\n";
  }

  echo "\nDone. You should now:\n";
  echo " - Create staff PINs via POST /api/staff.php (action=register) or insert directly.\n";
  echo " - Open front.html on the front desk iPad, kitchen.html in the kitchen.\n";
  echo " - Delete install.php after success.\n";

} catch (Throwable $e) {
  echo \"ERROR: \".$e->getMessage().\"\\n\";
}
echo \"</pre>\";
