<?php
require __DIR__.'/../db.php';

function bump(){ pdo()->exec('UPDATE bumps SET version=version+1 WHERE id=1'); }

if ($_SERVER['REQUEST_METHOD']==='POST'){
  $b = body();
  pdo()->beginTransaction();
  try {
    $stmt = pdo()->prepare('INSERT INTO orders(placed_by) VALUES (?)');
    $stmt->execute([(int)$b['placed_by']]);
    $orderId = pdo()->lastInsertId();

    $ps = pdo()->prepare('SELECT id, product_price FROM products WHERE id=?');
    $ins = pdo()->prepare('INSERT INTO order_items(order_id, product_id, qty, price) VALUES (?,?,?,?)');
    foreach ($b['items'] as $it){
      $ps->execute([(int)$it['product_id']]);
      $prod = $ps->fetch();
      if (!$prod) throw new Exception('Invalid product');
      $ins->execute([$orderId, (int)$prod['id'], (int)$it['qty'], $prod['product_price']]);
    }

    $ev = pdo()->prepare('INSERT INTO order_events(order_id, event, staff_id) VALUES (?,?,?)');
    $ev->execute([$orderId, 'created', (int)$b['placed_by']]);

    pdo()->commit();
    bump();
    json(['ok'=>true,'order_id'=>$orderId]);
  } catch (Exception $e){
    pdo()->rollBack();
    json(['error'=>$e->getMessage()],400);
  }
}

if ($_SERVER['REQUEST_METHOD']==='GET'){
  $scope = isset($_GET['scope']) ? $_GET['scope'] : 'open';
  $sql = 'SELECT o.*, sf.name as placed_by_name, sa.name as accepted_by_name
          FROM orders o
          JOIN staff sf ON sf.id=o.placed_by
          LEFT JOIN staff sa ON sa.id=o.accepted_by';
  $where = [];
  $params = [];
  if ($scope==='open'){
    $where[] = "DATE(o.created_at)=CURDATE() AND o.status IN ('pending','accepted','preparing')";
  }
  if ($scope==='mine' && isset($_GET['staff_id'])){
    $where[] = 'o.placed_by = ?';
    $params[] = (int)$_GET['staff_id'];
  }
  if ($where) $sql .= ' WHERE '.implode(' AND ', $where);
  $sql .= ' ORDER BY o.id DESC';
  $stmt = pdo()->prepare($sql);
  $stmt->execute($params);

  $orders = $stmt->fetchAll();
  if (!$orders) json(['orders'=>[]]);

  $ids = array_column($orders,'id');
  $in = implode(',', array_fill(0,count($ids),'?'));
  $it = pdo()->prepare("SELECT oi.*, p.name FROM order_items oi JOIN products p ON p.id=oi.product_id WHERE oi.order_id IN ($in)");
  $it->execute($ids);
  $byOrder = [];
  foreach ($it->fetchAll() as $row){ $byOrder[$row['order_id']][] = $row; }
  foreach ($orders as &$o){ $o['items'] = isset($byOrder[$o['id']]) ? $byOrder[$o['id']] : []; }

  json(['orders'=>$orders]);
}

if ($_SERVER['REQUEST_METHOD']==='PATCH'){
  parse_str(file_get_contents('php://input'), $b);
  $orderId = (int)($b['order_id'] ?? 0);
  $action = isset($b['action']) ? $b['action'] : '';
  $staffId = (int)($b['staff_id'] ?? 0);

  $map = [
    'accept'  => ['set'=>"status='accepted', accepted_by=?, accepted_at=NOW()", 'next'=>'accepted'],
    'prepare' => ['set'=>"status='preparing'", 'next'=>'preparing'],
    'ready'   => ['set'=>"status='ready'", 'next'=>'ready'],
  ];
  if (!isset($map[$action])) json(['error'=>'Invalid action'],400);

  $sql = 'UPDATE orders SET '.$map[$action]['set'].' WHERE id=?';
  if ($action==='accept'){
    $params = [$staffId, $orderId];
  } else {
    $params = [$orderId];
  }
  $stmt = pdo()->prepare($sql);
  $stmt->execute($params);

  $ev = pdo()->prepare('INSERT INTO order_events(order_id, event, staff_id) VALUES (?,?,?)');
  $ev->execute([$orderId, $map[$action]['next'], $staffId]);

  bump();
  json(['ok'=>true]);
}

json(['error'=>'Method not allowed'],405);
